/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.config;

import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.config.WizardConfig;
import com.ibm.hsc.iw.config.WizardConfigTask;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class WizardConfigParser
extends DOMParser
implements ErrorHandler {
    private static final String TRACE_MASKD = "JIWZWCPD";
    private static final String TRACE_MASKF = "JIWZWCPF";
    private static final String TRACE_MASKT = "JIWZWCPT";
    private static final String TASKS_ELEMENT = "TASKS";
    private static final String TASK_ELEMENT = "TASK";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String CLASS_INIT_STRING_ATTRIBUTE = "classInitString";
    private static final String LOCAL_ONLY_ATTRIBUTE = "localOnly";
    private static final String LOCAL_ONLY_TRUE_VALUE = "true";
    private String xMLFileName = null;

    public WizardConfigParser(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setErrorHandler(this);
        this.xMLFileName = string;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->WizardConfigParser(" + string + ")");
        }
    }

    public static void main(String[] stringArray) {
        WizardConfig wizardConfig = null;
        try {
            if (Trace.LEVEL >= 1) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(' ');
                    stringBuffer.append(stringArray[i]);
                }
                Trace.trace(TRACE_MASKT, "main() called with the following parameters :" + stringBuffer.toString());
            }
            if (stringArray.length != 1) {
                System.exit(-1);
            }
            wizardConfig = new WizardConfigParser(stringArray[0]).parseXML();
            System.out.println(wizardConfig);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public WizardConfig parseXML() throws IOException, SAXException, MalformedXMLException {
        WizardConfig wizardConfig = null;
        Document document = null;
        NodeList nodeList = null;
        Node node = null;
        boolean bl = false;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->parse()");
        }
        this.parse(new InputSource(new FileReader(this.xMLFileName)));
        bl = false;
        document = this.getDocument();
        if (document != null) {
            nodeList = document.getElementsByTagName(TASKS_ELEMENT);
            if (nodeList != null) {
                if (nodeList.getLength() == 1) {
                    node = nodeList.item(0);
                    if (Trace.LEVEL >= 3) {
                        Trace.trace(TRACE_MASKD, "Element found from top is " + node);
                    }
                    bl = true;
                } else if (nodeList.getLength() == 0) {
                    if (Trace.LEVEL >= 3) {
                        Trace.trace(TRACE_MASKD, "No TASKS element found from the top.");
                    }
                } else if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "More than one TASKS element found from the top.");
                }
            } else if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "No TASKS element found from the top.");
            }
        }
        if (!bl) {
            throw new MalformedXMLException("A single <TASKS> is expected.");
        }
        wizardConfig = this.parseTasks(node);
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-parse() returning : " + wizardConfig);
        }
        return wizardConfig;
    }

    public WizardConfig parseTasks(Node node) throws IllegalArgumentException, MalformedXMLException {
        WizardConfig wizardConfig = null;
        NodeList nodeList = null;
        Node node2 = null;
        String string = null;
        WizardConfigTask wizardConfigTask = null;
        String string2 = null;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->parseTasks( " + node + ")");
        }
        if (node != null) {
            nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node2 = nodeList.item(i);
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "Child node found of " + node2);
                }
                if (node2.getNodeType() == 1) {
                    string = node2.getNodeName();
                    if (TASK_ELEMENT.equals(string)) {
                        wizardConfigTask = this.parseTask(node2);
                        if (wizardConfig == null) {
                            wizardConfig = new WizardConfig();
                        }
                        wizardConfig.add(wizardConfigTask);
                        continue;
                    }
                    throw new MalformedXMLException("Unexpected element " + string + " under the " + TASKS_ELEMENT + " element");
                }
                if (node2.getNodeType() == 3) {
                    string2 = node2.getNodeValue();
                    if (string2 == null || string2.trim().length() <= 0) continue;
                    throw new MalformedXMLException("No text, other than whitespace, is allowed in the TASKS element.");
                }
                throw new MalformedXMLException("Only elements are expected under the TASKS element.");
            }
            if (wizardConfig == null) {
                throw new MalformedXMLException("No valid TASK element under the TASKS element.");
            }
        } else {
            throw new IllegalArgumentException("node is specified as null");
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-parseTasks(...) returning : " + wizardConfig);
        }
        return wizardConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WizardConfigTask parseTask(Node node) throws IllegalArgumentException, MalformedXMLException {
        WizardConfigTask wizardConfigTask = null;
        NodeList nodeList = null;
        NamedNodeMap namedNodeMap = null;
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->parseTask( " + node + ")");
        }
        if (node == null) throw new IllegalArgumentException("node is specified as null");
        nodeList = node.getChildNodes();
        if (nodeList.getLength() != 0) throw new MalformedXMLException("There are elements under the TASK element and this is unexpected.");
        namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) throw new IllegalArgumentException("node is not an element");
        node2 = namedNodeMap.getNamedItem(CLASS_ATTRIBUTE);
        if (node2 == null) {
            throw new MalformedXMLException("A class attribute is required on the TASK element.");
        }
        string = node2.getNodeValue();
        node3 = namedNodeMap.getNamedItem(CLASS_INIT_STRING_ATTRIBUTE);
        if (node3 != null) {
            string2 = node3.getNodeValue();
        }
        if ((node4 = namedNodeMap.getNamedItem(LOCAL_ONLY_ATTRIBUTE)) != null && (string3 = node4.getNodeValue()) != null && string3.toLowerCase().equals(LOCAL_ONLY_TRUE_VALUE)) {
            bl = true;
        }
        wizardConfigTask = new WizardConfigTask(string, string2, bl);
        if (Trace.LEVEL < 1) return wizardConfigTask;
        Trace.trace(TRACE_MASKT, "<-parseTask(...) returning : " + wizardConfigTask);
        return wizardConfigTask;
    }

    public void warning(SAXParseException sAXParseException) {
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "XML parsing WARNING : " + CommonXMLParser.where((SAXParseException)sAXParseException));
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "XML parsing ERROR: " + CommonXMLParser.where((SAXParseException)sAXParseException));
        }
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "XML parsing FATAL: " + CommonXMLParser.where((SAXParseException)sAXParseException));
        }
        throw sAXParseException;
    }
}

